/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.mantle.inventory;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1713;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_2338;
import net.minecraft.class_2586;
import net.minecraft.class_3917;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.tuple.Pair;
import slimeknights.mantle.inventory.BaseContainerMenu;
import slimeknights.mantle.inventory.WrapperSlot;

public class MultiModuleContainerMenu<TILE extends class_2586>
extends BaseContainerMenu<TILE> {
    public List<class_1703> subContainers = Lists.newArrayList();
    protected Map<Integer, class_1703> slotContainerMap = Maps.newHashMap();
    protected Map<class_1703, Pair<Integer, Integer>> subContainerSlotRanges = Maps.newHashMap();
    protected int subContainerSlotStart = -1;
    protected Set<class_1703> shiftClickContainers = Sets.newHashSet();

    public MultiModuleContainerMenu(class_3917<?> containerType, int id, @Nullable class_1661 inv, @Nullable TILE tile) {
        super(containerType, id, inv, tile);
    }

    public void addSubContainer(class_1703 subcontainer, boolean preferForShiftClick) {
        if (this.subContainers.isEmpty()) {
            this.subContainerSlotStart = this.field_7761.size();
        }
        this.subContainers.add(subcontainer);
        if (preferForShiftClick) {
            this.shiftClickContainers.add(subcontainer);
        }
        int begin = this.field_7761.size();
        for (class_1735 slot : subcontainer.field_7761) {
            WrapperSlot wrapper = new WrapperSlot(slot);
            this.method_7621(wrapper);
            this.slotContainerMap.put(wrapper.field_7874, subcontainer);
        }
        int end = this.field_7761.size();
        this.subContainerSlotRanges.put(subcontainer, (Pair<Integer, Integer>)Pair.of((Object)begin, (Object)end));
    }

    @Nullable
    public <CONTAINER extends class_1703> CONTAINER getSubContainer(Class<CONTAINER> clazz) {
        return this.getSubContainer(clazz, 0);
    }

    @Nullable
    public <CONTAINER extends class_1703> CONTAINER getSubContainer(Class<CONTAINER> clazz, int index) {
        for (class_1703 sub : this.subContainers) {
            if (clazz.isAssignableFrom(sub.getClass())) {
                --index;
            }
            if (index >= 0) continue;
            return (CONTAINER)((class_1703)clazz.cast(sub));
        }
        return null;
    }

    public class_1703 getSlotContainer(int slotNumber) {
        if (this.slotContainerMap.containsKey(slotNumber)) {
            return this.slotContainerMap.get(slotNumber);
        }
        return this;
    }

    @Override
    public boolean method_7597(class_1657 playerIn) {
        for (class_1703 sub : this.subContainers) {
            if (sub.method_7597(playerIn)) continue;
            return false;
        }
        return super.method_7597(playerIn);
    }

    public void method_7595(class_1657 playerIn) {
        for (class_1703 sub : this.subContainers) {
            sub.method_7595(playerIn);
        }
        super.method_7595(playerIn);
    }

    public void method_7593(int slotId, int dragType, class_1713 type, class_1657 player) {
        if (slotId == -999 && type == class_1713.field_7789) {
            for (class_1703 container : this.subContainers) {
                container.method_7593(slotId, dragType, type, player);
            }
        }
        super.method_7593(slotId, dragType, type, player);
    }

    @Override
    public class_1799 method_7601(class_1657 playerIn, int index) {
        class_1735 slot = (class_1735)this.field_7761.get(index);
        if (!slot.method_7681()) {
            return class_1799.field_8037;
        }
        class_1799 ret = slot.method_7677().method_7972();
        class_1799 itemstack = slot.method_7677().method_7972();
        class_1703 container = this.getSlotContainer(index);
        boolean nothingDone = true;
        if (container != this) {
            nothingDone &= this.moveToTileInventory(itemstack);
            nothingDone &= this.moveToPlayerInventory(itemstack);
        } else if (index < this.subContainerSlotStart || index < this.playerInventoryStart && this.subContainerSlotStart < 0) {
            nothingDone &= this.refillAnyContainer(itemstack, this.subContainers);
            nothingDone &= this.moveToPlayerInventory(itemstack);
            nothingDone &= this.moveToAnyContainer(itemstack, this.subContainers);
        } else if (index >= this.playerInventoryStart && this.playerInventoryStart >= 0) {
            nothingDone &= this.moveToTileInventory(itemstack);
            nothingDone &= this.moveToAnyContainer(itemstack, this.subContainers);
        } else {
            return class_1799.field_8037;
        }
        if (nothingDone) {
            return class_1799.field_8037;
        }
        return this.notifySlotAfterTransfer(playerIn, itemstack, ret, slot);
    }

    protected class_1799 notifySlotAfterTransfer(class_1657 player, class_1799 stack, class_1799 original, class_1735 slot) {
        slot.method_7670(stack, original);
        if (stack.method_7947() == original.method_7947()) {
            return class_1799.field_8037;
        }
        slot.method_7673(stack);
        slot.method_7667(player, stack);
        if (slot.method_7681() && slot.method_7677().method_7960()) {
            slot.method_7673(class_1799.field_8037);
        }
        return original;
    }

    protected boolean moveToTileInventory(class_1799 itemstack) {
        if (itemstack.method_7960()) {
            return false;
        }
        int end = this.subContainerSlotStart;
        if (end < 0) {
            end = this.playerInventoryStart;
        }
        return !this.method_7616(itemstack, 0, end, false);
    }

    protected boolean moveToPlayerInventory(class_1799 itemstack) {
        if (itemstack.method_7960()) {
            return false;
        }
        return this.playerInventoryStart > 0 && !this.method_7616(itemstack, this.playerInventoryStart, this.field_7761.size(), true);
    }

    protected boolean moveToAnyContainer(class_1799 itemstack, Collection<class_1703> containers) {
        if (itemstack.method_7960()) {
            return false;
        }
        for (class_1703 submodule : containers) {
            if (!this.moveToContainer(itemstack, submodule)) continue;
            return true;
        }
        return false;
    }

    protected boolean moveToContainer(class_1799 itemstack, class_1703 container) {
        Pair<Integer, Integer> range = this.subContainerSlotRanges.get(container);
        return !this.method_7616(itemstack, (Integer)range.getLeft(), (Integer)range.getRight(), false);
    }

    protected boolean refillAnyContainer(class_1799 itemstack, Collection<class_1703> containers) {
        if (itemstack.method_7960()) {
            return false;
        }
        for (class_1703 submodule : containers) {
            if (!this.refillContainer(itemstack, submodule)) continue;
            return true;
        }
        return false;
    }

    protected boolean refillContainer(class_1799 itemstack, class_1703 container) {
        Pair<Integer, Integer> range = this.subContainerSlotRanges.get(container);
        return !this.mergeItemStackRefill(itemstack, (Integer)range.getLeft(), (Integer)range.getRight(), false);
    }

    @Nullable
    public <TE extends class_2586> TE detectTE(Class<TE> clazz) {
        if (this.tile == null) {
            return null;
        }
        return (TE)((class_2586)ObjectUtils.firstNonNull((Object[])new class_2586[]{this.detectChest(this.tile.method_11016().method_10095(), clazz), this.detectChest(this.tile.method_11016().method_10078(), clazz), this.detectChest(this.tile.method_11016().method_10072(), clazz), this.detectChest(this.tile.method_11016().method_10067(), clazz)}));
    }

    @Nullable
    private <TE extends class_2586> TE detectChest(class_2338 pos, Class<TE> clazz) {
        if (this.tile == null) {
            return null;
        }
        if (this.tile.method_10997() == null) {
            return null;
        }
        class_2586 te = this.tile.method_10997().method_8321(pos);
        if (clazz.isInstance(te)) {
            return (TE)((class_2586)clazz.cast(te));
        }
        return null;
    }
}

